#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tcl.h>
#include <tk.h>

#include "tcl_interface.h"
#include "namespace.h"
#include "agent.h"
#include "utils.h"


extern NAMESPACE agent_classes;

int agentclasses_num(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
Tcl_ResetResult(interp);
Tcl_SetObjResult(interp,Tcl_NewIntObj(agent_classes.names_free));
return TCL_OK;
}

int agentclass_name(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: agentclass_name requires one argument",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: agentclass_name: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=agent_classes.names_free){
	Tcl_AppendResult(interp,"ERROR: agentclass_name: index too big",NULL);
	return TCL_ERROR;
	}	
Tcl_AppendResult(interp,agent_classes.names[i],NULL);
return TCL_OK;
}


int agentclass_attr_value(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i,j;
AGENTCLASS *ac;
Tcl_ResetResult(interp);
if(argc!=3){
	Tcl_AppendResult(interp,"ERROR: agentclass_attr_type requires three argument",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
j=atol(argv[2]);
if((i<0)||(j<0)){
	Tcl_AppendResult(interp,"ERROR: agentclass_attr_type: arguments must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=agent_classes.names_free){
	Tcl_AppendResult(interp,"ERROR: agentclass_attr_type: argument is too big",NULL);
	return TCL_ERROR;
	}	
ac=(AGENTCLASS *)agent_classes.data[i];	
if(j>=num_attributes()){
	Tcl_AppendResult(interp,"ERROR: agentclass_attr_type: argument is too big",NULL);
	return TCL_ERROR;
	}	
if(ac->attr_params[j].random){
	Tcl_AppendResult(interp,"random",NULL);
	return TCL_OK;
	}
switch(get_attribute(j)->type & 0xFFFF){
	case ATTR_INT: 	
		Tcl_SetObjResult(interp,Tcl_NewIntObj(ac->attr_params[j].value));
		break;
	case ATTR_BOOL: 	
		Tcl_SetObjResult(interp,Tcl_NewIntObj(ac->attr_params[j].value));
		break;
	case ATTR_SET: 	
		Tcl_SetObjResult(interp,Tcl_NewIntObj(ac->attr_params[j].value));
		break;
	case ATTR_HASH: 	
		Tcl_SetObjResult(interp,Tcl_NewIntObj(ac->attr_params[j].value));
		break;
	default:
		Tcl_AppendResult(interp,"abstract",NULL);
	}	
return TCL_OK;
}

int find_agentclass(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: find_agentclass requires one argument",NULL);
	return TCL_ERROR;
	}
for(i=0;i<agent_classes.names_free;i++)
	if(!strcmp(agent_classes.names[i],argv[1])){
		Tcl_SetObjResult(interp,Tcl_NewIntObj(i));
		return TCL_OK;
		}	
Tcl_SetObjResult(interp,Tcl_NewIntObj(-1));
return TCL_OK;
}

int add_agentclass1(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: find_agentclass requires one argument",NULL);
	return TCL_ERROR;
	}
add_new_agentclass(argv[1]);	
Tcl_SetObjResult(interp,Tcl_NewIntObj(0));
return TCL_OK;
}

/*
int agentclass_set_attr_type(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i,j;
AGENTCLASS *ac;
Tcl_ResetResult(interp);
if(argc!=4){
	Tcl_AppendResult(interp,"ERROR: agentclass_set_attr_type requires four arguments",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
j=atol(argv[2]);
if((i<0)||(j<0)){
	Tcl_AppendResult(interp,"ERROR: agentclass_set_attr_type: arguments must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=agent_classes.names_free){
	Tcl_AppendResult(interp,"ERROR: agentclass_set_attr_type: argument is too big",NULL);
	return TCL_ERROR;
	}	
ac=(AGENTCLASS *)agent_classes.data[i];	
if(j>=num_attributes()){
	Tcl_AppendResult(interp,"ERROR: agentclass_set_attr_type: argument is too big",NULL);
	return TCL_ERROR;
	}	
if(!strcmp(argv[3],"integer")){
	ac->attr_type[j]=ATTR_INT | (ac->attr_type[j] & 0xFFFF0000);
	return TCL_OK;
	}
if(!strcmp(argv[3],"boolean")){
	ac->attr_type[j]=ATTR_BOOL | (ac->attr_type[j] & 0xFFFF0000);
	return TCL_OK;
	}
if(!strcmp(argv[3],"set")){
	ac->attr_type[j]=ATTR_SET | (ac->attr_type[j] & 0xFFFF0000);
	return TCL_OK;
	}
if(!strcmp(argv[3],"hash")){
	ac->attr_type[j]=ATTR_HASH | (ac->attr_type[j] & 0xFFFF0000);
	return TCL_OK;
	}
return TCL_OK;
}

int agentclass_set_attr_name(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i,j;
AGENTCLASS *ac;
Tcl_ResetResult(interp);
if(argc!=4){
	Tcl_AppendResult(interp,"ERROR: agentclass_set_attr_name requires four arguments",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
j=atol(argv[2]);
if((i<0)||(j<0)){
	Tcl_AppendResult(interp,"ERROR: agentclass_set_attr_name: arguments must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=agent_classes.names_free){
	Tcl_AppendResult(interp,"ERROR: agentclass_set_attr_name: argument is too big",NULL);
	return TCL_ERROR;
	}	
ac=(AGENTCLASS *)agent_classes.data[i];	
if(j>=ac->attr_free){
	Tcl_AppendResult(interp,"ERROR: agentclass_set_attr_name: argument is too big",NULL);
	return TCL_ERROR;
	}	
free(ac->attr_names[j]);
ac->attr_names[j]=strdup(argv[3]);
return TCL_OK;
}

int agentclass_set_attr_value(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i,j;
AGENTCLASS *ac;
Tcl_ResetResult(interp);
if(argc!=4){
	Tcl_AppendResult(interp,"ERROR: agentclass_set_attr_value requires four arguments",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
j=atol(argv[2]);
if((i<0)||(j<0)){
	Tcl_AppendResult(interp,"ERROR: agentclass_set_attr_value: arguments must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=agent_classes.names_free){
	Tcl_AppendResult(interp,"ERROR: agentclass_set_attr_value: argument is too big",NULL);
	return TCL_ERROR;
	}	
ac=(AGENTCLASS *)agent_classes.data[i];	
if(j>=ac->attr_free){
	Tcl_AppendResult(interp,"ERROR: agentclass_set_attr_value: argument is too big",NULL);
	return TCL_ERROR;
	}	
if(!strcmp("random",argv[3])){
	ac->attr_type[j]=ac->attr_type[j] | ATTR_RANDOM;
	}else{	
	ac->attr_type[j]=ac->attr_type[j] & (~ATTR_RANDOM);
	ac->attribute[j]=atol(argv[3]);
	}
return TCL_OK;
}


int agentclass_add_attr(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
AGENTCLASS *ac;
Tcl_ResetResult(interp);
if(argc!=3){
	Tcl_AppendResult(interp,"ERROR: agentclass_remove_attr requires three argument",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if((i<0)){
	Tcl_AppendResult(interp,"ERROR: agentclass_remove_attr: arguments must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=agent_classes.names_free){
	Tcl_AppendResult(interp,"ERROR: agentclass_remove_attr: argument is too big",NULL);
	return TCL_ERROR;
	}	
ac=(AGENTCLASS *)agent_classes.data[i];	
add_attribute(ac,argv[2],ATTR_INT,0);
return TCL_OK;
}

*/
